#include "editor.h"

APPIEditor::APPIEditor(BResourceFile* resFile, long id) : DRKEditor(resFile, id)
{
	char	ignore[64];
	
	// We need the size
	fResFile->GetResourceInfo('APPI', fID, (char**)&ignore, &fSize);
	
	// I do this because the APPI resource is
	// a variable length resource.
	fOriginal = (APPIHeader*)new char[fSize];
	fModified = (APPIHeader*)new char[fSize];
	
	// Read in the resource
	fResFile->ReadResource('APPI', fID, (void*)fOriginal, 0, fSize);
	fResFile->ReadResource('APPI', fID, (void*)fModified, 0, fSize);
	
	SetupWindow();
}

APPIEditor::~APPIEditor()
{
	// The window has been closed so we dont do anything to it
	// but we have to free the following:
	
	delete [] fOriginal;
	delete [] fModified;
}

void APPIEditor::Activate()
{
	// You called?
	fWindow->Activate();
}

bool APPIEditor::Modified()
{
	// returns TRUE if the resource has been modified and
	// FALSE otherwise
	
	// Update the fModified structure from the UI and ...
	UpdateInfo();
	
	// ... compare it to the original
	return (!((fModified->app_type == fOriginal->app_type) &&
				(fModified->flags == fOriginal->flags)));
}

void APPIEditor::Save()
{
	// This gets called when we the data has been modified and
	// DRKTypeManager does the "Are you sure you want to
	// save changes" dialog and gets an OK
	
	// Update the fModified structure from the UI and ...
	UpdateInfo();
	
	// ... write it out.
	fResFile->WriteResource('APPI', fID, (void*)fModified, 0, fSize);
}

bool APPIEditor::CloseRequested()
{
	// This has to be explained carefully. This function
	// is called
	// 1) When the user closes the Resource File (called be DRKTypeManager
	// 2) When the user closes the APPIWindow (called by APPIWindow::QuitRequested)
	
	return gTypeManager->CloseEditorReq(this);
}

void APPIEditor::Close()
{
	// Bye bye
	fWindow->Close();
}

void APPIEditor::NotifyInfoChange()
{
	// All we really need to do is change the name of the
	// window to reflect this. The base class will take care of
	// updating the resource id
	DRKEditor::NotifyInfoChange();

	char	name[64];
	char	fileName[64];	
	fResFile->GetName(fileName);
	sprintf(name,"%s \'APPI\' - %d",name, fID);
	fWindow->SetTitle(name);
}

void APPIEditor::UpdateInfo()
{
	// Now for the nitty gritty stuff
	
	fModified->app_type = *((ulong*)fAppType->Text());
	
	fModified->flags = 0;
	fModified->flags |= (fMultiLaunch->Value() ?  0x00000001 : 0);
	fModified->flags |= (fExcluLaunch->Value() ? 0x00000002 : 0);
	fModified->flags |= (fBkgndApp->Value() ? 0x00000004 : 0);
	fModified->flags |= (fArgvOnly->Value() ? 0x00000008 : 0);
}

void APPIEditor::SetupWindow()
{
	// Let's setup the window name
	char	name[64];
	char	fileName[64];
	
	fResFile->GetName(fileName);
	sprintf(name,"%s \'APPI\' - %d",fileName, fID);
	
	// Now, the painful layput stuff
	BRect	windowFrame(kLeft,kTop,kLeft+kWidth,
				kTop+kHeight);

	fWindow = new APPIWindow(windowFrame, name, this);
	fWindow->Lock();
	
	BRect	rect(10,10,30,27);
	BRect	view = rect;
	view.OffsetTo(B_ORIGIN);

	fAppType = new BTextView(rect,"",view,B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW | B_BORDERED);
	char	app_type[5];
	app_type[4] = 0;
	*((ulong*)app_type) = fOriginal->app_type;
	fWindow->AddChild(fAppType);
	fAppType->SetMaxChars(4);
	fAppType->SetText(app_type,4);

	rect.right = 120;
	rect.OffsetBy(0,27);
	fBkgndApp = new BCheckBox(rect,"","Background Only",new BMessage('BLAH'));
	rect.OffsetBy(0,17);
	fArgvOnly = new BCheckBox(rect,"","Argv Only",new BMessage('BLAH'));

	rect.OffsetBy(0,27);
	fSinglLaunch = new BRadioButton(rect,"","Single Launch",new BMessage('BLAH'));
	rect.OffsetBy(0,17);
	fMultiLaunch = new BRadioButton(rect,"","Multiple Launch",new BMessage('BLAH'));
	rect.OffsetBy(0,17);
	fExcluLaunch = new BRadioButton(rect,"","Exclusive Launch",new BMessage('BLAH'));

	//BListView		*fTypesList;
	fWindow->AddChild(fBkgndApp);
	fWindow->AddChild(fArgvOnly);
	fWindow->AddChild(fSinglLaunch);
	fWindow->AddChild(fMultiLaunch);
	fWindow->AddChild(fExcluLaunch);
	//fWindow->AddChild(fTypesList);

	fBkgndApp->SetValue(fOriginal->flags & 0x00000004);
	fArgvOnly->SetValue(fOriginal->flags & 0x00000008);
	fSinglLaunch->SetValue(1);
	fMultiLaunch->SetValue(fOriginal->flags & 0x00000001);
	fExcluLaunch->SetValue(fOriginal->flags & 0x00000002);

	fWindow->Unlock();
	fWindow->Show();
}
